#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <vector>
#include <string.h>
#include <stdlib.h>
#include "SFTPBrowser.h"
#include "FileAbstraction.h"
#include "EditPane.h"
#include "SFTPEntry.h"

/*
 * the binary data from a gif
 */
#include "zurving_gif.c"

#define WIN_EOL "\r\n"
#define NIX_EOL "\n"

/*
 * A vector containing all the currently open tabs
 */
std::vector<EditPane*> panes = std::vector<EditPane*>();
/*
 * The graphical representation of that vector
 */
GtkWidget *notebook;
/*
 * The parent window - needed for dialogs and the what-not...
 */
GtkWidget *window;
/*
 * The string the user tried to find last time he/she used find.  Starts as NULL
 */
std::string* string_to_find = NULL;
/*
 * The string to use the next time the user uses the 'replace' funtion.  
 * Starts as NULL
 */
std::string* replacement_string = NULL;
/*
 * The menu for choosing end_of_line format
 */
GtkWidget *return_switch_item = NULL;
/*
 * The currently selected end_of_line format
 */
unsigned int how_many = 0;
char* eol = NULL;

static void closeFirstTabIfEmpty();

int hasPages(){
	return( gtk_notebook_get_n_pages ( GTK_NOTEBOOK(notebook) ) > 0 );
}

static void new_tab( FileAbstraction* file ){
	printf( "creating a new pane\n" );
	EditPane* pane = new EditPane( file, eol );
	panes.push_back( pane );
	gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), 
							  pane->getPane(),
							  pane->getLabel() );
}

static void get_find_replace_strings( std::string** tofind,
									  std::string** replacement ){
	GtkWidget* dialog = gtk_dialog_new_with_buttons( (gchar*)"replace",
						GTK_WINDOW( window ), GTK_DIALOG_MODAL,
						GTK_STOCK_OK, GTK_RESPONSE_ACCEPT,
						GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT,
						NULL );

	GtkWidget* box = gtk_vbox_new (FALSE, 0);
	gtk_widget_show( box );
	GtkWidget* topbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show( topbox );
	GtkWidget* bottombox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show( bottombox );

	GtkWidget* label = gtk_label_new ("replace:");
	gtk_widget_show( label );
	GtkWidget* textbox = gtk_entry_new_with_max_length( 256 );
	if( string_to_find != NULL ){
		gtk_entry_set_text( GTK_ENTRY(textbox), string_to_find->c_str() );
		gtk_entry_select_region( GTK_ENTRY(textbox), 0, string_to_find->size() );
	}
	gtk_widget_show( textbox );
	gtk_box_pack_start ( GTK_BOX(topbox), label, FALSE, TRUE, 0 );
	gtk_box_pack_start ( GTK_BOX(topbox), textbox, FALSE, TRUE, 0);

	GtkWidget* label2 = gtk_label_new ("with:");
	gtk_widget_show( label2 );
	GtkWidget* textbox2 = gtk_entry_new_with_max_length( 256 );
	if( replacement_string != NULL ){
		gtk_entry_set_text( GTK_ENTRY(textbox2), replacement_string->c_str() );
		gtk_entry_select_region( GTK_ENTRY(textbox2), 0, 
								replacement_string->size() );
	}
	gtk_widget_show( textbox2 );
	gtk_box_pack_start ( GTK_BOX(bottombox), label2, FALSE, TRUE, 0 );
	gtk_box_pack_start ( GTK_BOX(bottombox), textbox2, FALSE, TRUE, 0);

	gtk_box_pack_start ( GTK_BOX(box), topbox, FALSE, TRUE, 0 );
	gtk_box_pack_start ( GTK_BOX(box), bottombox, FALSE, TRUE, 0);	

	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox), box);

	gint response = gtk_dialog_run( GTK_DIALOG( dialog ) );
	switch( response ){
		case GTK_RESPONSE_ACCEPT:
			printf( "accepted\n" );
			(*tofind) = new std::string( 
						gtk_entry_get_text( GTK_ENTRY( textbox ) ) );
			(*replacement) = new std::string( 
						gtk_entry_get_text( GTK_ENTRY( textbox2 ) ) );
			break;
		default:
			break;
	}
	gtk_widget_destroy( textbox );
	gtk_widget_destroy( label );
	gtk_widget_destroy( textbox2 );
	gtk_widget_destroy( label2 );
	gtk_widget_destroy( topbox );
	gtk_widget_destroy( bottombox );
	gtk_widget_destroy( box );
	gtk_widget_destroy( dialog );
}

static std::string* get_find_string(){
	std::string* retval = NULL;
	GtkWidget* dialog = gtk_dialog_new_with_buttons( (gchar*)"find",
						GTK_WINDOW( window ), GTK_DIALOG_MODAL,
						GTK_STOCK_OK, GTK_RESPONSE_ACCEPT,
						GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT,
						NULL );

	GtkWidget* box = gtk_vbox_new (FALSE, 0);
	gtk_widget_show( box );
	GtkWidget* label = gtk_label_new ("search for:");
	gtk_widget_show( label );
	GtkWidget* textbox = gtk_entry_new_with_max_length( 256 );
	if( string_to_find != NULL ){
		gtk_entry_set_text( GTK_ENTRY(textbox), string_to_find->c_str() );
		gtk_entry_select_region( GTK_ENTRY(textbox), 0, string_to_find->size() );
	}
	gtk_widget_show( textbox );
	gtk_box_pack_start ( GTK_BOX(box), label, FALSE, TRUE, 0 );
	gtk_box_pack_start ( GTK_BOX(box), textbox, FALSE, TRUE, 0);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox), box);

	gint response = gtk_dialog_run( GTK_DIALOG( dialog ) );
	switch( response ){
		case GTK_RESPONSE_ACCEPT:
			printf( "accepted\n" );
			retval = new std::string( 
						gtk_entry_get_text( GTK_ENTRY( textbox ) ) );
			break;
		default:
			break;
	}
	gtk_widget_destroy( textbox );
	gtk_widget_destroy( label );
	gtk_widget_destroy( box );
	gtk_widget_destroy( dialog );
	return( retval );
}

static void showOpenDialog(){
	GtkWidget *dialog;
	dialog = gtk_file_chooser_dialog_new ("Open File",
					GTK_WINDOW( window ),
					GTK_FILE_CHOOSER_ACTION_OPEN,
					GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
					GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
					NULL);
	gtk_file_chooser_set_select_multiple( GTK_FILE_CHOOSER( dialog ), TRUE );
	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT){
	    closeFirstTabIfEmpty();
	    GSList* list = gtk_file_chooser_get_filenames ( GTK_FILE_CHOOSER(dialog) );
	    while( list != NULL ){
	        gchar* filename = (gchar*)(list->data); 
		FileAbstraction* file = new FileAbstraction( filename );
		new_tab( file );
		g_free (filename);
		int pagenum = gtk_notebook_get_n_pages ( GTK_NOTEBOOK(notebook) );
		gtk_notebook_set_current_page (GTK_NOTEBOOK(notebook), pagenum-1);
		list = list->next;
	    }
	}
	gtk_widget_destroy (dialog);
}

static void showSFTPOpenDialog(){
	SFTPBrowser* browser = new SFTPBrowser( window, 0 );
	FileAbstraction* file = browser->getFile();
	if( file != NULL ){
		closeFirstTabIfEmpty();
		new_tab( file );
		int pagenum = gtk_notebook_get_n_pages ( GTK_NOTEBOOK(notebook) );
		gtk_notebook_set_current_page (GTK_NOTEBOOK(notebook), pagenum-1);
	}
	delete( browser );
}

static void showSFTPSaveDialog(){
	SFTPBrowser* browser = new SFTPBrowser( window, 1 );
	FileAbstraction* file = browser->getFile();
	if( file != NULL ){
		if( hasPages() ){
			int pagenum = gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
			EditPane * pane = panes[pagenum];
			pane->saveFile( file );
		}
	}
	delete( browser );
}

static void showSaveDialog(){
		GtkWidget *dialog;
		dialog = gtk_file_chooser_dialog_new ("Save File",
						GTK_WINDOW( window ),
						GTK_FILE_CHOOSER_ACTION_SAVE,
						GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
						GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT,
						NULL);
		if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT){
			char *filename;
			filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
			FileAbstraction* file = new FileAbstraction( filename );
			if( hasPages() ){
				int pagenum = gtk_notebook_get_current_page (
								GTK_NOTEBOOK(notebook));
				EditPane * pane = panes[pagenum];
				pane->saveFile( file );
			}
			g_free (filename);
		}
		gtk_widget_destroy (dialog);
}

static void menuitem_response( gchar *string )
{
	if( strcmp( string, "file.save" ) == 0 ){
		if( hasPages() ){
			int pagenum = gtk_notebook_get_current_page ( GTK_NOTEBOOK(notebook) );
			EditPane* pane = panes[pagenum];
			FileAbstraction* path = pane->getPath();
			if( path == NULL ){
				showSaveDialog();
			}else{
				pane->saveFile( path );
			}
		}
	}else if( strcmp( string, "file.save_as" ) == 0 && hasPages() ){
		showSaveDialog();
	}else if( strcmp( string, "file.open" ) == 0 ){
		showOpenDialog();
	}else if( strcmp( string, "file.new" ) == 0 ){
		new_tab( NULL );
		int pagenum = gtk_notebook_get_n_pages ( GTK_NOTEBOOK(notebook) );
		gtk_notebook_set_current_page (GTK_NOTEBOOK(notebook), pagenum-1);
	}else if( strcmp( string, "file.close_tab") == 0 && hasPages() ){
		int pagenum = gtk_notebook_get_current_page (GTK_NOTEBOOK(notebook));
		printf( "removing page %i\n", pagenum );
		EditPane* pane = panes[pagenum];
		panes.erase( panes.begin()+pagenum );
		delete( pane );
		gtk_notebook_remove_page( GTK_NOTEBOOK(notebook), pagenum );
	}else if ( strcmp( string, "ssh.save_as" ) == 0 && hasPages() ){
		showSFTPSaveDialog();
	}else if ( strcmp( string, "ssh.open" ) == 0 ){
		showSFTPOpenDialog();
	}else if( strcmp( string, "edit.find" ) == 0 && hasPages() ){
		std::string* tofind = get_find_string();
		if( tofind != NULL ){
			if( string_to_find != NULL ) delete( string_to_find );
			string_to_find = tofind;
			int pagenum = gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
			EditPane* pane = panes[pagenum];
			pane->find( string_to_find );
		}
	}else if( strcmp( string, "edit.find_again" ) == 0 && hasPages() ){
		if( string_to_find == NULL ){
			menuitem_response( (char*)"edit.find" );
		}else{
			int pagenum = gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
			EditPane* pane = panes[pagenum];
			pane->find( string_to_find );
		}
	}else if( strcmp( string, "edit.replace" ) == 0 && hasPages() ){
		std::string* tofind = NULL;
		std::string* replacement = NULL;
		get_find_replace_strings( &tofind, &replacement );
		if( tofind != NULL && replacement != NULL ){
			int pagenum = gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
			EditPane* pane = panes[pagenum];
			pane->replace( tofind, replacement );
		}
	}else if( strcmp( string, "edit.return_switch" ) == 0 && hasPages() ){
		if( strcmp( eol, NIX_EOL ) == 0 ){
			memset( eol, 0, how_many );
			strcpy( eol, WIN_EOL );
			gtk_menu_item_set_label( GTK_MENU_ITEM(return_switch_item),
									 (gchar*)"Use *nix Format" );
		}else{
			memset( eol, 0, how_many );
			strcpy( eol, NIX_EOL );
			gtk_menu_item_set_label( GTK_MENU_ITEM(return_switch_item),
									 (gchar*)"Use Windows Format" );
		}
		int size = panes.size();
		int i;
		for( i=0; i < size; i++ ){
			panes[i]->setEOL( eol );
		}
	}else{
	    printf ("%s\n", string);
	}
}

static void closeFirstTabIfEmpty(){
	if( gtk_notebook_get_n_pages ( GTK_NOTEBOOK(notebook) ) == 1 ){
		EditPane* pane = panes[0];
		if( pane->isEmpty() ){
			menuitem_response( (gchar*)"file.close_tab" );
		}
	}
}

static gboolean delete_event( GtkWidget *widget,
                              GdkEvent  *event,
                              gpointer   data )
{
    /* If you return FALSE in the "delete-event" signal handler,
     * GTK will emit the "destroy" signal. Returning TRUE means
     * you don't want the window to be destroyed.
     * This is useful for popping up 'are you sure you want to quit?'
     * type dialogs. */

    //g_print ("delete event occurred\n");

    /* Change TRUE to FALSE and the main window will be destroyed with
     * a "delete-event". */

    return FALSE;
}

/* Another callback */
static void destroy( GtkWidget *widget,
                     gpointer   data )
{
    gtk_main_quit ();
}

int main( int argc, char *argv[] ){
	// set the current end-of-line;
	how_many = strlen( NIX_EOL );
	if( strlen( WIN_EOL ) > how_many ) how_many = strlen( WIN_EOL );
	how_many++;
	eol = (char*)malloc( how_many );
	memset( eol, 0, how_many );
	strcpy( eol, NIX_EOL );

    /* GtkWidget is the storage type for widgets */
	GtkWidget *menubar;
	GtkWidget *box1;

	/* Menu items */
	GtkWidget *file;
	GtkWidget *file_menu;
		GtkWidget *new_item;
		GtkWidget *open_item;
		GtkWidget *save_item;
		GtkWidget *save_as_item;
		GtkWidget *ssh;
		GtkWidget *ssh_menu;
			GtkWidget* ssh_open_item;
			GtkWidget* ssh_save_as_item;
		GtkWidget *close_tab_item;
		GtkWidget *quit_item;
	GtkWidget *edit;
	GtkWidget *edit_menu;
		GtkWidget *find_item;
		GtkWidget *find_again_item;
		GtkWidget *replace_item;
	GtkWidget *help;
	GtkWidget *help_menu;
		GtkWidget *about_item;
    
    /* This is called in all GTK applications. Arguments are parsed
     * from the command line and are returned to the application. */
    gtk_init (&argc, &argv);

	/* Load an icon to decorate the window */
	GError* error = NULL;
	GdkPixbufLoader* loader = gdk_pixbuf_loader_new ();
	gdk_pixbuf_loader_write ( loader, zurving_gif, sizeof( zurving_gif ), &error );
	gdk_pixbuf_loader_close ( loader, &error );
	GdkPixbuf *icon = gdk_pixbuf_loader_get_pixbuf ( loader );
    
    /* create a new window */
    window = gtk_window_new ( GTK_WINDOW_TOPLEVEL );
	gtk_window_set_position( GTK_WINDOW( window ), GTK_WIN_POS_CENTER);
	gtk_window_set_default_size( GTK_WINDOW( window ), 640, 480 );
	gtk_window_set_icon( GTK_WINDOW( window ), icon );
    
    /* When the window is given the "delete-event" signal (this is given
     * by the window manager, usually by the "close" option, or on the
     * titlebar), we ask it to call the delete_event () function
     * as defined above. The data passed to the callback
     * function is NULL and is ignored in the callback function. */
    g_signal_connect (window, "delete-event",
		      G_CALLBACK (delete_event), NULL);
    
    /* Here we connect the "destroy" event to a signal handler.  
     * This event occurs when we call gtk_widget_destroy() on the window,
     * or if we return FALSE in the "delete-event" callback. */
    g_signal_connect (window, "destroy",
		      G_CALLBACK (destroy), NULL);
    
    /* Sets the border width of the window. */
    gtk_container_set_border_width (GTK_CONTAINER (window), 2);

	/* Create a box to hold the notebook and the menubar */
	box1 = gtk_vbox_new (FALSE, 0);
	/* Put the box into the main window. */
    gtk_container_add (GTK_CONTAINER (window), box1);

	/* Create a Menubar for the users to use */
	menubar = gtk_menu_bar_new();	
	gtk_box_pack_start (GTK_BOX(box1), menubar, FALSE, TRUE, 0);

	/* Create the menus we need */
	file_menu = gtk_menu_new ();
	edit_menu = gtk_menu_new ();
	help_menu = gtk_menu_new ();

	/* for accelerators */
	GtkAccelGroup *accel_group = gtk_accel_group_new();
	gtk_window_add_accel_group(GTK_WINDOW(window), accel_group);
	/* file menu items */
	//new_item = gtk_menu_item_new_with_label ("New");
	new_item = gtk_image_menu_item_new_from_stock(GTK_STOCK_NEW, accel_group);
	gtk_widget_add_accelerator(new_item, "activate", accel_group, 
      							GDK_n, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	//open_item = gtk_menu_item_new_with_label ("Open");
	open_item = gtk_image_menu_item_new_from_stock(GTK_STOCK_OPEN, accel_group);
	gtk_widget_add_accelerator(open_item, "activate", accel_group, 
      							GDK_o, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	//save_item = gtk_menu_item_new_with_label ("Save");
	save_item = gtk_image_menu_item_new_from_stock(GTK_STOCK_SAVE, accel_group);
	gtk_widget_add_accelerator(save_item, "activate", accel_group, 
      							GDK_s, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	//save_as_item = gtk_menu_item_new_with_label ("Save As");
	save_as_item = gtk_image_menu_item_new_from_stock(GTK_STOCK_SAVE_AS,
														accel_group);

	ssh_menu = gtk_menu_new();
	ssh = gtk_menu_item_new_with_label ("SFTP");
	gtk_widget_show (ssh);
	ssh_open_item = gtk_image_menu_item_new_from_stock( GTK_STOCK_OPEN, NULL );
	gtk_menu_item_set_label( GTK_MENU_ITEM(ssh_open_item),(gchar*)"SFTP Open" );
	ssh_save_as_item = gtk_image_menu_item_new_from_stock(GTK_STOCK_SAVE_AS,
														NULL);
	gtk_menu_item_set_label( GTK_MENU_ITEM(ssh_save_as_item),
									 (gchar*)"SFTP Save As" );

	//close_tab_item = gtk_menu_item_new_with_label ("Close Tab");
	close_tab_item = gtk_image_menu_item_new_from_stock(GTK_STOCK_CLOSE,
														accel_group);
	gtk_menu_item_set_label( GTK_MENU_ITEM(close_tab_item),
														(gchar*)"Close Tab" );
    //quit_item = gtk_menu_item_new_with_label ("Quit");
	quit_item = gtk_image_menu_item_new_from_stock(GTK_STOCK_QUIT, accel_group);
	/* edit menu items */
	//find_item = gtk_menu_item_new_with_label ("Find");
	find_item = gtk_image_menu_item_new_from_stock(GTK_STOCK_FIND, accel_group);
	gtk_widget_add_accelerator(find_item, "activate", accel_group, 
      							GDK_f, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	//find_again_item = gtk_menu_item_new_with_label ("Find Again");
	find_again_item = gtk_image_menu_item_new_from_stock(GTK_STOCK_FIND,
														accel_group);
	gtk_menu_item_set_label( GTK_MENU_ITEM(find_again_item),
									 (gchar*)"Find Again" );
	gtk_widget_add_accelerator(find_again_item, "activate", accel_group, 
      							GDK_F3, GdkModifierType(0), GTK_ACCEL_VISIBLE);
	//replace_item = gtk_menu_item_new_with_label ("Replace");
	replace_item =  gtk_image_menu_item_new_from_stock(GTK_STOCK_FIND_AND_REPLACE,
														 accel_group);
	gtk_widget_add_accelerator(new_item, "activate", accel_group, 
      							GDK_r, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);
	//return_switch_item = gtk_menu_item_new_with_label ("Use Windows Format");
	return_switch_item = gtk_image_menu_item_new_from_stock(GTK_STOCK_CONVERT,
														 accel_group);
	gtk_menu_item_set_label( GTK_MENU_ITEM(return_switch_item),
									 (gchar*)"Use Windows Format" );
	/* help menu items */
	//about_item = gtk_menu_item_new_with_label ("About");
	about_item = gtk_image_menu_item_new_from_stock(GTK_STOCK_INFO,
														 accel_group);
	gtk_menu_item_set_label( GTK_MENU_ITEM(about_item), (gchar*)"About" );
	gtk_menu_shell_append (GTK_MENU_SHELL (file_menu), new_item);
	gtk_menu_shell_append (GTK_MENU_SHELL (file_menu), open_item);
    gtk_menu_shell_append (GTK_MENU_SHELL (file_menu), save_item);
    gtk_menu_shell_append (GTK_MENU_SHELL (file_menu), save_as_item);

	gtk_menu_shell_append ( GTK_MENU_SHELL (file_menu), ssh );
	gtk_menu_shell_append (GTK_MENU_SHELL (ssh_menu), ssh_open_item);
    gtk_menu_shell_append (GTK_MENU_SHELL (ssh_menu), ssh_save_as_item);

    gtk_menu_shell_append (GTK_MENU_SHELL (file_menu), close_tab_item);
    gtk_menu_shell_append (GTK_MENU_SHELL (file_menu), quit_item);
    gtk_menu_shell_append (GTK_MENU_SHELL (edit_menu), find_item);
    gtk_menu_shell_append (GTK_MENU_SHELL (edit_menu), find_again_item);
    gtk_menu_shell_append (GTK_MENU_SHELL (edit_menu), replace_item);
    gtk_menu_shell_append (GTK_MENU_SHELL (edit_menu), return_switch_item);
    gtk_menu_shell_append (GTK_MENU_SHELL (help_menu), about_item);

    /* Attach the callback functions to the activate signal */
    g_signal_connect_swapped (new_item, "activate",
                              G_CALLBACK (menuitem_response),
                              (gpointer) "file.new");
    g_signal_connect_swapped (open_item, "activate",
                              G_CALLBACK (menuitem_response),
                              (gpointer) "file.open");
    g_signal_connect_swapped (save_item, "activate",
                              G_CALLBACK (menuitem_response),
                              (gpointer) "file.save");
    g_signal_connect_swapped (save_as_item, "activate",
                              G_CALLBACK (menuitem_response),
                              (gpointer) "file.save_as");
    g_signal_connect_swapped (ssh_open_item, "activate",
                              G_CALLBACK (menuitem_response),
                              (gpointer) "ssh.open");
    g_signal_connect_swapped (ssh_save_as_item, "activate",
                              G_CALLBACK (menuitem_response),
                              (gpointer) "ssh.save_as");
    g_signal_connect_swapped (close_tab_item, "activate",
                              G_CALLBACK (menuitem_response),
                              (gpointer) "file.close_tab");
    g_signal_connect_swapped (find_item, "activate",
                              G_CALLBACK (menuitem_response),
                              (gpointer) "edit.find");
    g_signal_connect_swapped (find_again_item, "activate",
                              G_CALLBACK (menuitem_response),
                              (gpointer) "edit.find_again");
    g_signal_connect_swapped (replace_item, "activate",
                              G_CALLBACK (menuitem_response),
                              (gpointer) "edit.replace");
    g_signal_connect_swapped (return_switch_item, "activate",
                              G_CALLBACK (menuitem_response),
                              (gpointer) "edit.return_switch");
    g_signal_connect_swapped (about_item, "activate",
                              G_CALLBACK (menuitem_response),
                              (gpointer) "help.about");

    /* We can attach the Quit menu item to our exit function */
    g_signal_connect_swapped (quit_item, "activate",
                              G_CALLBACK (destroy),
                              (gpointer) "file.quit");

    /* We do need to show menu items */
    gtk_widget_show (new_item);
    gtk_widget_show (open_item);
    gtk_widget_show (save_item);
    gtk_widget_show (save_as_item);
    gtk_widget_show (ssh_open_item);
    gtk_widget_show (ssh_save_as_item);
    gtk_widget_show (close_tab_item);
    gtk_widget_show (quit_item);
    gtk_widget_show (find_item);
    gtk_widget_show (find_again_item);
    gtk_widget_show (replace_item);
    gtk_widget_show (return_switch_item);
    gtk_widget_show (about_item);

	file = gtk_menu_item_new_with_label ("File");
	edit = gtk_menu_item_new_with_label ("Edit");
	help = gtk_menu_item_new_with_label ("Help");
    gtk_widget_show (file);
	gtk_widget_show (edit);
	gtk_widget_show (help);
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (file), file_menu);
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (ssh), ssh_menu);
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (edit), edit_menu);
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (help), help_menu);
	gtk_menu_bar_append (GTK_MENU_BAR (menubar), file);
	gtk_menu_bar_append (GTK_MENU_BAR (menubar), edit);
	gtk_menu_bar_append (GTK_MENU_BAR (menubar), help);

	/* Create a notebook to hold all of the editing frames */
	notebook = gtk_notebook_new();
	gtk_notebook_set_tab_pos( GTK_NOTEBOOK( notebook ), GTK_POS_LEFT );
    
    /* This packs the button into the window (a gtk container). */
	gtk_box_pack_start (GTK_BOX(box1), notebook, TRUE, TRUE, 0);

	/*
	gtk_notebook_append_page( GTK_NOTEBOOK( notebook), page );
	*/
    
    /* The final step is to display this newly created widget. */
	gtk_widget_show (menubar);
    gtk_widget_show (notebook);
	gtk_widget_show (box1);
    
    /* and the window */
    gtk_widget_show (window);

	printf( "number of args %i\n", argc );
	if( argc < 2 ){
		new_tab( 0 );
	}else{
		int i = 0;
		for( i = 1; i < argc; i++ ){
			FileAbstraction* file = new FileAbstraction( argv[i] );
			new_tab( file );
			int pagenum = gtk_notebook_get_n_pages ( GTK_NOTEBOOK(notebook) );
			gtk_notebook_set_current_page (GTK_NOTEBOOK(notebook), pagenum-1);
		}
	}
    
    /* All GTK applications must have a gtk_main(). Control ends here
     * and waits for an event to occur (like a key press or
     * mouse event). */
    gtk_main ();
    
    return 0;
}
