#include <stdlib.h>
#include <string>
#include <iostream>
#include <fstream>
#include "SFTPFileAbstraction.h"
#include "SFTPClient.h"

SFTPFileAbstraction::SFTPFileAbstraction( const char* path, const char* server,
						 const char* username, const char* password )
	:FileAbstraction( path ){
	this->error = NULL;
	this->path = new std::string( path );
	this->server = new std::string( server );
	this->username = new std::string( username );
	this->password = new std::string( password );
}

SFTPFileAbstraction::~SFTPFileAbstraction(){
	delete( path );
	delete( server );
	delete( username );
	delete( password );
}

std::string* SFTPFileAbstraction::read(){
	if( error != NULL ) delete( error );
	error = NULL;
	std::string* text = NULL;
	printf( "reading sftp file: %s\n", path->c_str() );
	SFTPClient* client = new SFTPClient( server, username, password );
	if( client->hasError() ){
		error = new std::string( "unable to connect to sftp server" );
	}else{
		text = client->readFile( path );
		if( client->hasError() ){
			text = NULL;
			error = new std::string( "unable to read file from sftp server" );
		}
	}
	delete( client );
	return( text );
}

void SFTPFileAbstraction::write( std::string* data ){
	if( error != NULL ) delete( error );
	error = NULL;
	SFTPClient* client = new SFTPClient( server, username, password );
	if( client->hasError() ){
		error = new std::string( "unable to connect to sftp server" );
	}else{
		client->writeFile( path, data );
		if( client->hasError() ){
			error = new std::string( "unable to write file to sftp server" );
		}
	}
	delete( client );	
}