#ifndef SFTP_CLIENT_H
#define SFTP_CLIENT_H

#include <libssh/sftp.h>
#include <stdlib.h>
#include <string>
#include <vector>
#include "SFTPEntry.h"

class SFTPClient {
	private:
		ssh_session session;
		sftp_session sftp;
		int error;
	        int fakeKeyboardInteractive( std::string* user, std::string* password );
		std::string UpToLow(std::string str);
	public:
		SFTPClient( std::string* server, std::string* username, 
					std::string* password );
		// Constructor
		~SFTPClient();
		void listFiles( std::vector<SFTPEntry*>* toFill, std::string* path );
		void readSymlink( std::string* path, std::string* symlink );
		std::string* readFile( std::string* path );
		void writeFile( std::string* path, std::string* text );
		int hasError();
};

#endif
