#include <libssh/sftp.h>
#include <string>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <vector>
#include "SFTPClient.h"

SFTPClient::SFTPClient( std::string* server, std::string* username, 
					std::string* password ){
	sftp = NULL;
	session = NULL;
	error = SSH_OK;
	session = ssh_new();
	int verbosity = 0;//SSH_LOG_PROTOCOL;
	int port = 22;
	if( session == NULL ){
		fprintf( stderr, "Error allocating session: %s\n",
				 ssh_get_error(session) );
	}
	ssh_options_set(session, SSH_OPTIONS_HOST, server->c_str() );
	ssh_options_set(session, SSH_OPTIONS_LOG_VERBOSITY, &verbosity);
	ssh_options_set(session, SSH_OPTIONS_PORT, &port);
	error = ssh_connect(session);
	if (error != SSH_OK) {
		fprintf(stderr, "Error connecting to localhost: %s\n",
       			ssh_get_error(session));
	}else{
		unsigned char* hash = NULL;
		size_t hlen = ssh_get_pubkey_hash(session, &hash);
		std::string key = std::string( (char*)hash, hlen );
		printf( "server provided hash '%s'\n", key.c_str() );
		//error = ssh_userauth_password( session, username->c_str(), 
		//				 password->c_str() );
		error = fakeKeyboardInteractive( username, password );

		if( error != SSH_OK ){
			fprintf(stderr, "Error authenticating user: %s\n",
			       	ssh_get_error(session));
		}else{
			sftp = sftp_new(session);
			if (sftp == NULL){
				fprintf( stderr, "Error allocating SFTP session: %s\n",
						 ssh_get_error(session) );
			}else{
				error = sftp_init(sftp);
				if (error != SSH_OK){
					fprintf( stderr, "Error initializing SFTP session: %i.\n",
							 sftp_get_error(sftp) );
				}
			}
		}
	}
}

SFTPClient::~SFTPClient(){
	printf( "deleting sftp client\n" );
	if( sftp != NULL ) sftp_free( sftp );
	if( session != NULL ){
		ssh_disconnect( session );
		ssh_free( session );
	}
	printf( "done deleting sftp client\n" );
}

int SFTPClient::fakeKeyboardInteractive( std::string* user,
					 std::string* password ){
    int rc;
    rc = ssh_userauth_kbdint(session, user->c_str(),NULL);
    int count = 0;
    while( rc == SSH_AUTH_INFO && count < 5 ){
        std::string name, instruction;
	int nprompts, iprompt;

	name = std::string( ssh_userauth_kbdint_getname(session) );
	instruction = std::string( ssh_userauth_kbdint_getinstruction(session) );
	nprompts = ssh_userauth_kbdint_getnprompts(session);

	if (name != std::string("") ) printf("%s\n", name.c_str() );
	if (instruction != std::string("") ) printf("%s\n", instruction.c_str() );
	for (iprompt = 0; iprompt < nprompts; iprompt++){
	    std::string prompt;
	    char echo;

	    prompt = std::string(ssh_userauth_kbdint_getprompt(session, iprompt, &echo));
	    std::string lower = UpToLow( prompt );
	    if( lower == std::string("password: ") ){
		ssh_userauth_kbdint_setanswer( session, iprompt, 
					       password->c_str() );
	    }else{
	        printf( "prompt: %s\n", prompt.c_str() );
		ssh_userauth_kbdint_setanswer( session, iprompt, "" );
	    }
	}
	rc = ssh_userauth_kbdint(session, NULL, NULL);
	count++;   
    }
    int retval = SSH_OK;
    if( rc != SSH_AUTH_SUCCESS ) retval = SSH_ERROR;
    return( retval );
}

std::string SFTPClient::UpToLow(std::string str) {
    int length = str.length();
    for (int i=0; i < length; i++ ){ 
	str[i] = tolower(str[i]);
    }
    return str;
}

void SFTPClient::listFiles( std::vector<SFTPEntry*>* toFill, 
							std::string* path ){
	sftp_dir dir;
	sftp_attributes attributes;
	dir = sftp_opendir( sftp, path->c_str() );
	if( !dir ){
		error = SSH_ERROR;
	}
	while((attributes = sftp_readdir( sftp, dir )) != NULL ){
		//printf( "perms for '%s': %.8o\n", attributes->name,
		//		 attributes->permissions );
		char* temp = (char*)malloc( 80 );
		memset( temp, 0, 80 );
		sprintf( temp, "%.8o", attributes->permissions );
		SFTPEntry* entry = new SFTPEntry( attributes->name, temp );
		free( temp );
		toFill->push_back( entry );
		sftp_attributes_free( attributes );
	}
	int rc = sftp_closedir( dir );
	if( rc != SSH_OK ){
		error = rc;
	}
}

void SFTPClient::readSymlink( std::string* path, std::string* symlink ){
	printf( "reading symlink %s\n" , symlink->c_str() );
	char* new_path = sftp_readlink( sftp, symlink->c_str() );
	path->append( new_path );
}

std::string* SFTPClient::readFile( std::string* path ){
	sftp_file file;
	int access_type;
	char buffer[1024];
	int nbytes = -1;
	int rc = SSH_OK;
	
	std::string* retval = NULL;

	access_type = O_RDONLY;
	printf( "sftp opening: %s\n", path->c_str() );
	file = sftp_open(sftp, path->c_str(), access_type, 0);
	if (file == NULL){
		fprintf(stderr, "Can't open file for reading: %s\n", 
							ssh_get_error(session));
    	error = SSH_ERROR;
	}else{
		retval = new std::string();
		nbytes = sftp_read(file, buffer, sizeof(buffer));
		while (nbytes > 0){
			retval->append( buffer, nbytes );
		    nbytes = sftp_read(file, buffer, sizeof(buffer));
		}
	}

	if (nbytes < 0){
		fprintf(stderr, "Error while reading file: %s\n", ssh_get_error(session));
		sftp_close(file);
		error = SSH_ERROR;
	}

	rc = sftp_close(file);
	return( retval );
}

void SFTPClient::writeFile( std::string* path, std::string* text ){
	sftp_file file;
	int access_type;
	int rc = SSH_OK;
	
	access_type = O_WRONLY|O_CREAT;
	printf( "sftp writing: %s\n", path->c_str() );
	sftp_attributes attributes = sftp_stat( sftp, path->c_str() );
	mode_t perms = S_IRUSR|S_IWUSR; //|S_IRGRP|S_IWGRP|S_IROTH;
	if( attributes != NULL ){
		perms = attributes->permissions;
		sftp_unlink( sftp, path->c_str() );
	}
	file = sftp_open(sftp, path->c_str(), access_type, perms );
	if (file == NULL){
		fprintf(stderr, "Can't open file for writing: %s\n", 
							ssh_get_error(session));
    	error = SSH_ERROR;
	}else{
		rc = sftp_write(file, text->c_str(), text->size() );
		rc = sftp_close(file);
	}
}

int SFTPClient::hasError(){
	return( (error != SSH_OK) );
}
