#ifndef SFTP_BROWSER_H
#define SFTP_BROWSER_H
#include <string>
#include <vector>
#include <gtk/gtk.h>
#include "SFTPClient.h"
#include "FileAbstraction.h"
#include "SFTPEntry.h"

class SFTPBrowser {
	private:
		static const unsigned char symlink_png[];
		static const unsigned char folder_png[];
		static const unsigned char file_png[];

		GdkPixbuf *symlink_icon;
		GdkPixbuf *folder_icon;
		GdkPixbuf *file_icon;

		GtkWidget * ok_button;
		GtkWidget * cancel_button;
		GtkWidget * buttonbox;

		GtkWidget * connlab;
		GtkWidget * connbut;
		GtkWidget * connbox;
		GtkWidget * passlab;
		GtkWidget * passtxt;
		GtkWidget * passbox;
		GtkWidget * serlab;
		GtkWidget * usertxt;
		GtkWidget * userbox;
		GtkWidget * userlab;
		GtkWidget * servlab;
		GtkWidget * servtxt;
		GtkWidget * servbox;
		GtkWidget * topbox;
		GtkWidget * scrolledWindow;
		GtkWidget * list;
		GtkWidget * box;
		GtkWidget * filename;
		GtkWidget * dialog;
		GtkListStore  *store;
		FileAbstraction* file;

		std::string* path;

		std::vector<SFTPEntry*> files;

		void listFiles( std::string* server, std::string* username, 
						std::string* password );
		void connect();
		void onRowActivated ();
		void ok();
		void cancel();
		void processFile( SFTPEntry* entry );
		void showErrorDialog( const char* message, const char* title );
		void onCursorChanged ();
	public:
		SFTPBrowser( GtkWidget* window, int save );
		// Constructor
		~SFTPBrowser();
		FileAbstraction* getFile();
		static void static_connect( GtkWidget *widget, gpointer data );
		static void static_onRowActivated (	GtkTreeView *treeview,
											GtkTreePath *path,
											GtkTreeViewColumn  *col,
											gpointer userdata );
		static void static_onCursorChanged( GtkTreeView *treeview,
											gpointer userdata );
		static void static_ok( GtkWidget *widget, gpointer data );
		static void static_cancel( GtkWidget *widget, gpointer data );
};

enum
{
  COL_TYPE = 0,
  COL_NAME,
  NUM_COLS
} ;

#endif