#include <string>
#include <string.h>
#include <vector>
#include <gtk/gtk.h>
#include <algorithm>
#include <stdio.h>
#include <stdlib.h>
#include "SFTPClient.h"
#include "FileAbstraction.h"
#include "SFTPFileAbstraction.h"
#include "SFTPBrowser.h"
#include "file_png.c"
#include "folder_png.c"
#include "symlink_png.c"
#include "SFTPEntry.h"

struct EntryComparitor {
	bool operator() ( SFTPEntry* a, SFTPEntry* b ){
		 return( *(a->getPath()) < *(b->getPath() ) );
	}
} comparitor;

SFTPBrowser::SFTPBrowser( GtkWidget* window, int save ){
	files = std::vector<SFTPEntry*>();
	path = NULL;
	file = NULL;

	/* load up the images we need for the display */
	GError* error = NULL;

	GdkPixbufLoader* loader = gdk_pixbuf_loader_new ();
	gdk_pixbuf_loader_write ( loader, symlink_png, sizeof( symlink_png ), &error );
	gdk_pixbuf_loader_close( loader, &error );
	symlink_icon = gdk_pixbuf_loader_get_pixbuf ( loader );

	GdkPixbufLoader* loader2 = gdk_pixbuf_loader_new ();	
	gdk_pixbuf_loader_write ( loader2, folder_png, sizeof( folder_png ), &error );
	gdk_pixbuf_loader_close( loader2, &error );
	folder_icon = gdk_pixbuf_loader_get_pixbuf ( loader2 );

	GdkPixbufLoader* loader3 = gdk_pixbuf_loader_new ();
	gdk_pixbuf_loader_write ( loader3, file_png, sizeof( file_png ), &error );
	gdk_pixbuf_loader_close ( loader3, &error );
	file_icon = gdk_pixbuf_loader_get_pixbuf ( loader3 );	

	std::string text = std::string("Open");
	if( save ) text = std::string("Save");
	std::string title = std::string("sftp open");
	if( save ) title = std::string("sftp save");
	dialog = gtk_dialog_new_with_buttons( (gchar*)title.c_str(),
						GTK_WINDOW( window ), GTK_DIALOG_MODAL,
						NULL );

	//					text.c_str(), GTK_RESPONSE_ACCEPT,
	//					GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT,


	gtk_window_set_default_size( GTK_WINDOW( dialog ), 320, 320 );

	box = gtk_vbox_new (FALSE, 0);
	gtk_widget_show( box );

	topbox = gtk_vbox_new( FALSE, 0 );
	gtk_widget_show( topbox );

	servbox = gtk_hbox_new( FALSE, 0 );
	gtk_widget_show( servbox );
	userbox = gtk_hbox_new( FALSE, 0 );
	gtk_widget_show( userbox );
	passbox = gtk_hbox_new( FALSE, 0 );
	gtk_widget_show( passbox );
	connbox = gtk_hbox_new( FALSE, 0 );
	gtk_widget_show( connbox );

	servlab = gtk_label_new ("server:");
	gtk_misc_set_alignment ( GTK_MISC( servlab ), 0, .5 );
	gtk_widget_show( servlab );
	servtxt = gtk_entry_new_with_max_length( 256 );
	gtk_widget_show( servtxt );
	gtk_box_pack_start( GTK_BOX(servbox), servlab, TRUE, TRUE, 0 );
	gtk_box_pack_start( GTK_BOX(servbox), servtxt, FALSE, FALSE, 0 );
	gtk_box_pack_start( GTK_BOX(topbox), servbox, FALSE, TRUE, 0 );

	userlab = gtk_label_new ("user:");
	gtk_misc_set_alignment ( GTK_MISC( userlab ), 0, .5 );
	gtk_widget_show( userlab );
	usertxt = gtk_entry_new_with_max_length( 256 );
	gtk_widget_show( usertxt );
	gtk_box_pack_start( GTK_BOX(userbox), userlab, TRUE, TRUE, 0 );
	gtk_box_pack_start( GTK_BOX(userbox), usertxt, FALSE, FALSE, 0 );
	gtk_box_pack_start( GTK_BOX(topbox), userbox, FALSE, TRUE, 0 );

	passlab = gtk_label_new ("password:");
	gtk_misc_set_alignment ( GTK_MISC( passlab ), 0, .5 );
	gtk_widget_show( passlab );
	passtxt = gtk_entry_new_with_max_length( 256 );
	gtk_entry_set_visibility ( GTK_ENTRY(passtxt), FALSE );
	gtk_widget_show( passtxt );
	gtk_box_pack_start( GTK_BOX(passbox), passlab, TRUE, TRUE, 0 );
	gtk_box_pack_start( GTK_BOX(passbox), passtxt, FALSE, FALSE, 0 );
	gtk_box_pack_start( GTK_BOX(topbox), passbox, FALSE, TRUE, 0 );

	connlab = gtk_label_new ("");
	gtk_misc_set_alignment ( GTK_MISC( connlab ), 0, .5 );
	gtk_widget_show( connlab );
	connbut = gtk_button_new_with_label( "connect" );
	gtk_widget_show( connbut );
	gtk_box_pack_start( GTK_BOX(connbox), connlab, TRUE, TRUE, 0 );
	gtk_box_pack_start( GTK_BOX(connbox), connbut, FALSE, FALSE, 0 );
	gtk_box_pack_start( GTK_BOX(topbox), connbox, FALSE, TRUE, 0 );

    g_signal_connect ( connbut, "clicked", G_CALLBACK (static_connect), this);

	list = gtk_tree_view_new();
	gtk_widget_show( list );
	GtkTreeSelection * selection;
	selection = gtk_tree_view_get_selection( GTK_TREE_VIEW( list ) );
	gtk_tree_selection_set_mode( selection, GTK_SELECTION_SINGLE );
	GtkCellRenderer     *renderer;

	/* --- Column #1 --- */
	renderer = gtk_cell_renderer_pixbuf_new();
	gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (list),
                                               -1,      
                                               "",  
                                               renderer,
                                               "pixbuf", COL_TYPE,
                                               NULL);

	/* --- Column #2 --- */
	renderer = gtk_cell_renderer_text_new ();
	gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (list),
                                               -1,      
                                               "name",  
                                               renderer,
                                               "text", COL_NAME,
                                               NULL);

	store = gtk_list_store_new (NUM_COLS, GDK_TYPE_PIXBUF, G_TYPE_STRING, G_TYPE_STRING);
	gtk_tree_view_set_model (GTK_TREE_VIEW (list), GTK_TREE_MODEL (store));

	GtkTreeViewColumn * column = NULL;
	column = gtk_tree_view_get_column(GTK_TREE_VIEW(this->list),0);
	gtk_tree_view_column_set_fixed_width( column, 32 );
	column = gtk_tree_view_get_column(GTK_TREE_VIEW(this->list),1);
	gtk_tree_view_column_set_fixed_width( column, 240 );

	/* The tree view has acquired its own reference to the
	 *  model, so we can drop ours. That way the model will
	 *  be freed automatically when the tree view is destroyed */

	g_signal_connect(list, "row-activated", (GCallback) static_onRowActivated, 
					 this);
	g_signal_connect(list, "cursor-changed", (GCallback) static_onCursorChanged,
					 this);

	scrolledWindow = gtk_scrolled_window_new( NULL, NULL );
	gtk_widget_show( scrolledWindow );
	gtk_container_add(GTK_CONTAINER(scrolledWindow), list);

	gtk_box_pack_start ( GTK_BOX(box), topbox, FALSE, TRUE, 0 );
	gtk_box_pack_start ( GTK_BOX(box), scrolledWindow, TRUE, TRUE, 0 );

	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox), box);

	if( save ){
		ok_button = gtk_button_new_from_stock( GTK_STOCK_SAVE );
	}else{
		ok_button = gtk_button_new_from_stock( GTK_STOCK_OPEN );
	}
	cancel_button = gtk_button_new_from_stock( GTK_STOCK_CANCEL );
	//cancel_button = gtk_dialog_add_button (GTK_DIALOG (dialog),
     //                                  GTK_STOCK_CANCEL,
     //                                  GTK_RESPONSE_CANCEL);
	buttonbox = gtk_hbox_new( FALSE, 0 );

	filename = gtk_entry_new_with_max_length( 256 );
	if( save ){
		gtk_widget_show( filename );		
	}

	gtk_box_pack_start( GTK_BOX(buttonbox), filename, TRUE, FALSE, 0 );
	gtk_box_pack_start( GTK_BOX(buttonbox), ok_button, FALSE, FALSE, 0 );
	gtk_box_pack_start( GTK_BOX(buttonbox), cancel_button, FALSE, FALSE, 0 );
	gtk_container_add(GTK_CONTAINER (GTK_DIALOG(dialog)->action_area), 
					  buttonbox );
	gtk_widget_show( ok_button );
	gtk_widget_show( cancel_button );
	gtk_widget_show( buttonbox );
	g_signal_connect ( ok_button, "clicked", G_CALLBACK (static_ok), this);
	g_signal_connect ( cancel_button, "clicked", G_CALLBACK (static_cancel),
					   this);

	gint response = gtk_dialog_run( GTK_DIALOG( dialog ) );
	switch( response ){
		case GTK_RESPONSE_ACCEPT:
			//retval = new std::string( 
			//			gtk_entry_get_text( GTK_ENTRY( textbox ) ) );
			break;
		default:
			break;
	}

}

SFTPBrowser::~SFTPBrowser(){

	//free( symlink_icon );
	//free( folder_icon );
	//free( file_icon );

	gtk_widget_destroy( connlab );
	gtk_widget_destroy( connbut );
	gtk_widget_destroy( connbox );
	gtk_widget_destroy( passlab );
	gtk_widget_destroy( passtxt );
	gtk_widget_destroy( passbox );
	gtk_widget_destroy( userlab );
	gtk_widget_destroy( usertxt );
	gtk_widget_destroy( userbox );
	gtk_widget_destroy( servlab );
	gtk_widget_destroy( servtxt );
	gtk_widget_destroy( servbox );
	gtk_widget_destroy( topbox );
	gtk_widget_destroy( list );
	gtk_widget_destroy( scrolledWindow );
	gtk_widget_destroy( box );
	gtk_widget_destroy( ok_button );
	gtk_widget_destroy( cancel_button );
	gtk_widget_destroy( buttonbox );
	gtk_widget_destroy( dialog );

	if( path != NULL ) delete( path );
}

void SFTPBrowser::listFiles( std::string* server, std::string* username, 
							 std::string* password ){
	SFTPClient* client = new SFTPClient( server, username, password );
	if( client->hasError() ){
		showErrorDialog( "unable to connect to server.  bad user/password?",
						 "unable to connect" );
		delete ( client );
		return;
	}
	printf( "clearing current display\n" );
	gtk_list_store_clear(store);
	while (!files.empty()){
		SFTPEntry* entry = files.back();
		delete( entry );
		files.pop_back();
	}
	if( path == NULL ){
		printf( "path is NULL...  using home folder...\n" );
		path = new std::string("/home/");
		path->append(*username);
		path->append(std::string("/"));
	}
	printf( "ls %s\n", path->c_str() );
	client->listFiles( &files, path );
	if( client->hasError() ){
		showErrorDialog( "error communicating with server",
						 "sftp error" );
		delete ( client );
		return;
	}
	std::sort( files.begin(), files.end(), comparitor );
	int size = files.size();
	printf( "listed %i files\n", size );
	int i = 0;
	GtkTreeIter iter;
	for( i=0; i < size; i++ ){
		const std::string* path = files[i]->getPath();
		if( path->find('.',0) != 0 || *path == std::string("..") ){
			gtk_list_store_append( store, &iter );
			GdkPixbuf* buff = NULL;
			switch( files[i]->getType() ){
				case SFTPEntry::FOLDER:
					buff = folder_icon;
					break;
				case SFTPEntry::SYMLINK:
					buff = symlink_icon;
					break;
				default:
					buff = file_icon;
			}
			gtk_list_store_set (store, &iter,
	                      		COL_TYPE, buff,
	                      		COL_NAME, files[i]->getPath()->c_str(),
	                      		-1);
		}
	}
	delete ( client );
	gtk_label_set_text( GTK_LABEL(connlab), (gchar*)(path->c_str()) );
}

FileAbstraction* SFTPBrowser::getFile(){
	return( file );
}

void SFTPBrowser::static_connect( GtkWidget *widget, gpointer data ){
	SFTPBrowser* browser = (SFTPBrowser*)data;
	browser->connect();
}

void SFTPBrowser::connect(){
	printf( "checking required info before connecting...\n" );
	char* server = (char*)gtk_entry_get_text( GTK_ENTRY( servtxt ) );
	char* username = (char*)gtk_entry_get_text( GTK_ENTRY( usertxt ) );
	char* password = (char*)gtk_entry_get_text( GTK_ENTRY( passtxt ) );

	std::string s_server = std::string( server );
	std::string s_username = std::string( username );
	std::string s_password = std::string( password );

	int reqInfo = strcmp( "", server );
	reqInfo = reqInfo && strcmp( "", username );
	reqInfo = reqInfo && strcmp( "", password );
	if( reqInfo ){
		printf( "all information provided... connecting...\n" );
		listFiles( &s_server, &s_username, &s_password );
	}
}

void SFTPBrowser::static_onRowActivated (	GtkTreeView *treeview,
											GtkTreePath *path,
											GtkTreeViewColumn  *col,
											gpointer userdata ){
	SFTPBrowser* browser = (SFTPBrowser*)userdata;
	browser->onRowActivated();
}

void SFTPBrowser::static_onCursorChanged (	GtkTreeView *treeview,
											gpointer userdata ){
	SFTPBrowser* browser = (SFTPBrowser*)userdata;
	browser->onCursorChanged();
}

void SFTPBrowser::onCursorChanged (){
	GtkTreeIter iter;
	GtkTreeModel *model;
	GtkTreeSelection* sel = gtk_tree_view_get_selection(GTK_TREE_VIEW(list));
	if( gtk_tree_selection_get_selected( sel, &model, &iter ) ){
		gchar* selectedName;
		gtk_tree_model_get( model, &iter, COL_NAME, &selectedName, -1 );
		//printf( "selected name: %s\n", selectedName );
		gtk_entry_set_text( GTK_ENTRY( filename ), selectedName );
	}
}

void SFTPBrowser::onRowActivated (){
	this->ok();
}

void SFTPBrowser::static_ok( GtkWidget *widget, gpointer data ){
	SFTPBrowser* browser = (SFTPBrowser*)data;
	browser->ok();
}

void SFTPBrowser::processFile( SFTPEntry* entry ){
	if( entry->getType() == SFTPEntry::FILE ){
		// create an sftp file abstraction
		std::string filepath = std::string( *path );
		filepath.append( *(entry->getPath()) );

		char* server = (char*)gtk_entry_get_text( GTK_ENTRY( servtxt ) );
		char* username = (char*)gtk_entry_get_text( GTK_ENTRY( usertxt ) );
		char* password = (char*)gtk_entry_get_text( GTK_ENTRY( passtxt ) );
		const char* path = filepath.c_str();

		SFTPFileAbstraction* abstr = new SFTPFileAbstraction( path,	server,
															  username,
															  password );
		this->file = abstr;
		gtk_dialog_response( GTK_DIALOG(dialog), GTK_RESPONSE_ACCEPT );
	}else if( entry->getType() == SFTPEntry::FOLDER ){
		if( (*entry->getPath()) == std::string("..") ){
			//change path to parent;
			std::string temp = ( path->substr( 0, path->length()-1 ) );
			temp = temp.substr(0,temp.rfind("/"));
			temp.append("/");
			delete( path );
			path = new std::string( temp );
			printf("moving to path %s\n", this->path->c_str() );
			this->connect();
		}else{
			path->append(*entry->getPath());
			path->append(std::string("/"));
			printf("moving to path %s\n", this->path->c_str() );
			this->connect();
		}
	}else if( entry->getType() == SFTPEntry::SYMLINK ){
		printf( "checking required info before connecting...\n" );
		char* server = (char*)gtk_entry_get_text( GTK_ENTRY( servtxt ) );
		char* username = (char*)gtk_entry_get_text( GTK_ENTRY( usertxt ) );
		char* password = (char*)gtk_entry_get_text( GTK_ENTRY( passtxt ) );

		std::string s_server = std::string( server );
		std::string s_username = std::string( username );
		std::string s_password = std::string( password );
	
		int reqInfo = strcmp( "", server );
		reqInfo = reqInfo && strcmp( "", username );
		reqInfo = reqInfo && strcmp( "", password );
		if( reqInfo ){
			printf( "all information provided... connecting...\n" );
			SFTPClient* client = new SFTPClient( &s_server, &s_username,
												 &s_password );
			if( client->hasError() ){
				showErrorDialog( "error communicating with server",
								 "sftp error" );
				delete ( client );
				return;
			}
			std::string newpath;
			std::string temp = std::string( *path );
			temp.append( *(entry->getPath()) );
			client->readSymlink( &newpath, &temp );
			if( client->hasError() ){
				showErrorDialog( "error communicating with server",
								 "sftp error" );
				delete ( client );
				return;
			}
			if( newpath.at( newpath.size()-1 ) == '/' && newpath.size() != 1 ){
				newpath = newpath.substr( 0, newpath.size()-1 ); //chop off
															 	 //any trailing
																 //slashes
			}
			printf( "new path %s\n", newpath.c_str() );
			std::string name;
			if( newpath.at(0) == '/' ){
				if( path != NULL ) delete( path );
				name = newpath.substr( newpath.rfind("/")+1, newpath.size() );
				std::string tpath = newpath.substr(0,newpath.rfind("/"));
				path = new std::string( tpath );
				path->append("/");
			}else{
				if( newpath.find("/") == std::string::npos ){
					name = newpath;
				}else{
					while( newpath.find("../") == 0 ){
						std::string up = std::string( *path );
						up = up.substr( 0, up.size()-1 ); // remove slash
						up = up.substr( 0, up.rfind("/") ); // go up a dir
						delete( path );
						path = new std::string( up );
						path->append("/");
						newpath = newpath.substr( 3, newpath.size() );
					}
					std::string tpath = newpath.substr(0,newpath.rfind("/"));
					name = newpath.substr(newpath.rfind("/")+1,newpath.size());
					path->append( tpath );
					path->append("/");
				}
			}

			printf( "using path: %s\n", path->c_str() );
			printf( "looking for %s\n", name.c_str() );

			std::vector<SFTPEntry*> toFill;
			client->listFiles( &toFill, path );
			if( client->hasError() ){
				showErrorDialog( "error communicating with server",
								 "sftp error" );
				delete ( client );
				return;
			}
			SFTPEntry* toProcess = NULL;
			unsigned int i=0;
			for( i=0; i < toFill.size(); i++ ){
				if( name == *(toFill[i]->getPath()) ){
					toProcess = toFill[i];
				}else{
					delete( toFill[i] );
				}
			}
			if( toProcess == NULL ){
				showErrorDialog( "link to non-existant file", "sftp error" );
			}else{
				processFile( toProcess );
				delete( toProcess );
			}
			delete( client );
		}
	}
}

void SFTPBrowser::showErrorDialog( const char* message, const char* title ){
	GtkWidget* dialog = gtk_message_dialog_new( GTK_WINDOW(this->dialog),
            GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK,
            "%s", message);
	gtk_window_set_title(GTK_WINDOW(dialog), title );
	gtk_dialog_run(GTK_DIALOG(dialog));
	gtk_widget_destroy( dialog );
}

void SFTPBrowser::ok(){
	printf( "ok\n" );
	const gchar* text = gtk_entry_get_text( GTK_ENTRY(filename) );
	if( strcmp( text, "" ) != 0 ){
		SFTPEntry* entry = NULL;
		int i = 0;
		int size = files.size();
		std::string fname = std::string( text );
		for( i=0; i < size; i++ ){
			if( (*files[i]->getPath()) == fname ){
				entry = files[i];
				i = size; // break out of the loop;
			}
		}
		int needToDelete = false;
		if( entry == NULL ){ // should only be true when
							 // user enters a file name
			needToDelete = true;
			entry = new SFTPEntry( fname.c_str(), SFTPEntry::FILE );
		}
		processFile( entry );
		if( needToDelete ) delete( entry );
	}	
}

void SFTPBrowser::static_cancel( GtkWidget *widget, gpointer data ){
	SFTPBrowser* browser = (SFTPBrowser*)data;
	browser->cancel();
}

void SFTPBrowser::cancel(){
	printf( "cancel\n" );
	gtk_dialog_response ( GTK_DIALOG(dialog), GTK_RESPONSE_CANCEL );
}
