#include <stdlib.h>
#include <string>
#include <iostream>
#include <fstream>
#include "FileAbstraction.h"

FileAbstraction::FileAbstraction( const char* path ){
	this->path = new std::string( path );
	this->error = NULL;
}

FileAbstraction::~FileAbstraction(){
	delete( path );
}

std::string* FileAbstraction::getPath(){
	return( path );
}

std::string* FileAbstraction::read(){
	printf( "reading normal file: %s\n", path->c_str() );
	std::ifstream myReadFile;
	myReadFile.open( path->c_str() );
	std::string* text = NULL;
	if (myReadFile.is_open()) {
		text = new std::string();
		std::string temp;
		while (!myReadFile.eof()) {
			getline(myReadFile,temp);
			text->append( temp + std::string( "\n" ) );
		}
		myReadFile.close();
	}
	return( text );
}

void FileAbstraction::write( std::string* data ){
	std::ofstream myfile;
	myfile.open ( path->c_str() );
	if( myfile.is_open() ){
		myfile << data->c_str();
		myfile.close();
	}
}

std::string* FileAbstraction::getError(){
	return( error );
}