#ifndef EDIT_PANE_H
#define EDIT_PANE_H

#include <string>
#include <gtk/gtk.h>
#include <gtksourceview/gtksourcebuffer.h>
#include <gtksourceview/gtksourcelanguagemanager.h>
#include "FileAbstraction.h"

class EditPane {
	private:
		GtkWidget *scrolledWindow;
		GtkWidget *text;
		GtkWidget *label;

		GtkSourceBuffer *sBuf;
		GtkSourceLanguageManager *lm;

		std::string* nix_eol;
		std::string* win_eol;
		std::string* mac_eol;
		FileAbstraction* file;
		char* end_of_line;
		void setPath( FileAbstraction* file );
		void replaceInString( std::string* source, std::string* tofind,
								std::string* replacement );
		void updateHighlighting();
		void setLabel( FileAbstraction* file );
		void showError( const char* message, const char* title );
	public:
		EditPane( FileAbstraction* file, char* end_of_line );
		// Constructor
		~EditPane();
		GtkWidget* getPane();
		GtkWidget* getLabel();
		void openFile( FileAbstraction* file );
		void saveFile( FileAbstraction* file );
		FileAbstraction* getPath();
		void find( std::string* tofind );
		void replace( std::string* tofind, std::string* replacement );
		void setEOL( char* end_of_line );
		void setLanguage( std::string filename );
		int isEmpty();
};

#endif
