#include <gtk/gtk.h>
#include <gtksourceview/gtksourceview.h>
#include <gtksourceview/gtksourcebuffer.h>
#include <gtksourceview/gtksourcelanguage.h>
#include <gtksourceview/gtksourcelanguagemanager.h>
#include <string.h>
#include <string>
#include <stdlib.h>
#include <glib.h>
#include "EditPane.h"

#define EOL "\n"

EditPane::EditPane( FileAbstraction* file, char* end_of_line){
	nix_eol = new std::string( "\n" );
	win_eol = new std::string( "\r\n" );
	mac_eol = new std::string( "\r" );
	setEOL( end_of_line );
	this->file = NULL;
	/* a label for showing in the notebook */
	label = gtk_label_new("untitled");
	gtk_widget_show( label );
	scrolledWindow = gtk_scrolled_window_new( NULL, NULL );
	gtk_widget_show( scrolledWindow );

	PangoFontDescription *font_desc;

	/* Now create a GtkSourceLanguageManager */
	lm = gtk_source_language_manager_new();
	const gchar* const* specs = gtk_source_language_manager_get_search_path( lm );
	int i=0;
	while( specs[i] != NULL ){
	    printf("search path: %s\n", specs[i] );
	    i++;
	}

	/* and a GtkSourceBuffer to hold text (similar to GtkTextBuffer) */
	sBuf = GTK_SOURCE_BUFFER (gtk_source_buffer_new (NULL));
	g_object_ref (lm);
	g_object_set_data_full ( G_OBJECT (sBuf), "languages-manager",
    						 lm, (GDestroyNotify) g_object_unref);

	/* Create the GtkSourceView and associate it with the buffer */
	text = gtk_source_view_new_with_buffer(sBuf);
	gtk_source_view_set_auto_indent( GTK_SOURCE_VIEW( text ), true );
	gtk_source_view_set_highlight_current_line( GTK_SOURCE_VIEW( text ), true );
	gtk_source_view_set_smart_home_end( GTK_SOURCE_VIEW( text ), 
					    GTK_SOURCE_SMART_HOME_END_BEFORE );
	gtk_source_view_set_indent_width( GTK_SOURCE_VIEW( text ), 4 );
	gtk_source_view_set_show_line_numbers( GTK_SOURCE_VIEW( text ), true );

	/* Set default Font name,size */
        //linux: Monospace 8
	//windoze: Monospace 8
	font_desc = pango_font_description_from_string ("Monospace 8");
        gtk_widget_modify_font (text, font_desc);
	gtk_widget_show( text );
	//g_signal_connect(text, "key_press_event", G_CALLBACK(static_on_key_press), this);
	gtk_container_add(GTK_CONTAINER(scrolledWindow), text);
	/* End changes to source view */
	openFile( file );
}

EditPane::~EditPane(){
	printf( "deleting pane\n" );
	delete( nix_eol );
	delete( win_eol );
	delete( mac_eol );
	if( file != NULL ) delete( file );
	//gtk_widget_destroy( GTK_WIDGET(sBuf)

	// these seem to cause problems...  may cause a memory leak
	// but that's better that crashes...

	//gtk_widget_destroy( GTK_WIDGET(text) );
	//gtk_widget_destroy( GTK_WIDGET(status) );
	//gtk_widget_destroy( GTK_WIDGET(label) );
	//gtk_widget_destroy( GTK_WIDGET(scrolledWindow) );
	//gtk_widget_destroy( GTK_WIDGET(box) );
}

void EditPane::setPath( FileAbstraction* file ){
	if( file != NULL && file != this->file ){
		delete( this->file );
		this->file = file;
	}
}

FileAbstraction* EditPane::getPath(){
	return( file );
}

GtkWidget* EditPane::getPane(){
	return( scrolledWindow );
}

GtkWidget* EditPane::getLabel(){
	return( label );
}

void EditPane::setLabel( FileAbstraction* file ){
	std::string path_str = std::string( *file->getPath() );
	std::string file_name = std::string();
	unsigned int index = path_str.rfind( "/" );
	//printf( "index: %i\n", index );
	//printf( "npos: %i\n", path_str.npos );
	if( index != path_str.npos ){
		file_name = path_str.substr( index + 1 );
	}else{
		index = path_str.rfind( "\\" );
		file_name = path_str.substr( index + 1 );
	}
	gtk_label_set_text( GTK_LABEL( label ), file_name.c_str() );
}

void EditPane::saveFile( FileAbstraction* file ){
	// make sure we've got the right kind of return lines
	GtkTextBuffer* buff = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text));
	GtkTextIter start, end;
	gtk_text_buffer_get_bounds ( buff, &start, &end );
	std::string dat = gtk_text_buffer_get_text( buff, &start, &end, FALSE );
	std::string* ret = new std::string( end_of_line );
	replaceInString( &dat, win_eol, nix_eol );
	replaceInString( &dat, mac_eol, nix_eol );
	replaceInString( &dat, nix_eol, ret );
	file->write( &dat );
	std::string* error = file->getError();
	delete( ret );
	if( error != NULL ){
		showError( error->c_str(), "save error" );
	}else{
		setLabel( file );
		setPath( file );
		setLanguage( std::string( *file->getPath() ) );
	}
}

void EditPane::openFile( FileAbstraction* file ){
	GtkTextBuffer* buff = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text));
	if( file != NULL ){
		setLabel( file );
		std::string* ret = new std::string( EOL );
		std::string* text = file->read();
		std::string* error = file->getError();
		if( error != NULL ){
			showError( error->c_str(), "open error" );
			if( text != NULL ) delete( text );
			text = new std::string("");
		}else if( text == NULL ){
			showError( "unable to open file", "open error" );
			text = new std::string("");
		}
		replaceInString( text, win_eol, nix_eol );
		replaceInString( text, mac_eol, nix_eol );
		replaceInString( text, nix_eol, ret );
		gsize bytes_read;
		gsize bytes_written;
		GError * gerror = NULL;
		gchar* data = g_locale_to_utf8 (text->c_str(),-1,&bytes_read, &bytes_written, &gerror);
		if( gerror != NULL ){
		    g_error_free( gerror );
		}else{
		    gtk_text_buffer_set_text( buff, data , bytes_written );
		}
		if( data != NULL ) g_free( data );
		delete( text );
		delete( ret );
		setLabel( file );
		setPath( file );
		setLanguage( std::string(*file->getPath()) );
	}
}

void EditPane::find( std::string* tofind ){
	printf( "finding %s\n", tofind->c_str() );
	GtkTextBuffer* buff = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text));
	GtkTextIter start, end;
	gtk_text_buffer_get_bounds ( buff, &start, &end );

	GtkTextMark* cursorMarc = gtk_text_buffer_get_insert( buff );
	GtkTextIter cursor;
	gtk_text_buffer_get_iter_at_mark( buff, &cursor, cursorMarc );

	GtkTextIter match_start;
	GtkTextIter match_end;

	gboolean found = gtk_text_iter_forward_search( &cursor, tofind->c_str(),
							GTK_TEXT_SEARCH_TEXT_ONLY,
							&match_start, &match_end, NULL );
	if( !found ){
		found = gtk_text_iter_forward_search( &start, tofind->c_str(),
							GTK_TEXT_SEARCH_TEXT_ONLY,
							&match_start, &match_end, NULL );
	}

	if( found ){
	        gtk_text_buffer_place_cursor ( buff, &match_end );
		gtk_text_buffer_select_range( buff, &match_end, &match_start );
		GtkTextMark *last_pos;
		last_pos = gtk_text_buffer_create_mark (buff, "last_pos", 
                                              &match_end, FALSE);
		gtk_text_view_scroll_mark_onscreen( GTK_TEXT_VIEW(text), last_pos );
	}
}

void EditPane::replaceInString( std::string* source, std::string* tofind,
								std::string* replacement ){
    unsigned int start_pos = 0;
    size_t index = 0;
    std::string temp();
    while( (index = source->find( *tofind, start_pos )) != std::string::npos ){
	start_pos = index + replacement->size();
	source->replace( index, tofind->size(), *replacement );
    }
} 

void EditPane::replace( std::string* tofind, std::string* replacement ){
	printf("replacing '%s' with '%s'\n", tofind->c_str(), replacement->c_str());
	GtkTextBuffer* buff = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text));
	GtkTextIter start, end;
	gtk_text_buffer_get_bounds ( buff, &start, &end );
	std::string contents = 
			std::string(gtk_text_buffer_get_text( buff, &start, &end, FALSE ));
	replaceInString( &contents, tofind, replacement );
	gtk_text_buffer_set_text( buff, contents.c_str(), contents.size() );
}

void EditPane::setEOL( char* end_of_line ){
	this->end_of_line = end_of_line;
}

void EditPane::setLanguage( std::string filename ){
	std::string path = std::string( filename );
	if( path.find("/") != std::string::npos ){
	    path = path.substr( path.rfind("/")+1, path.length() );
	}else if( path.find("\\") != std::string::npos ){
	    path = path.substr( path.rfind("\\")+1, path.length() );
	}
	GtkSourceLanguage *language = 
			gtk_source_language_manager_guess_language(lm,path.c_str(),NULL);
	if( language == NULL ){
	    g_print ("No language found for filename `%s'\n", path.c_str() );
	}else{
		g_print ("setting language to`%s/%s for file %s'\n",
				 gtk_source_language_get_section (language), 
				 gtk_source_language_get_name (language),
				 path.c_str() );
		gtk_source_buffer_set_language (GTK_SOURCE_BUFFER(sBuf), language);
	}
}

void EditPane::showError( const char* message, const char* title ){
	GtkWidget* dialog = gtk_message_dialog_new( GTK_WINDOW(scrolledWindow),
            GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK,
            "%s", message);
	gtk_window_set_title(GTK_WINDOW(dialog), title );
	gtk_dialog_run(GTK_DIALOG(dialog));
	gtk_widget_destroy( dialog );
}

int EditPane::isEmpty(){
	GtkTextBuffer* buff = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text));
	return( ( gtk_text_buffer_get_char_count( buff ) == 0 ) );
}





